-- --------------------------------------------------------------------------
-- Copyright  2008 PlayFirst, Inc. All Rights Reserved.
--
-- This material is the confidential trade secret and proprietary
-- information of PlayFirst, Inc. It may not be reproduced, used, disclosed,
-- sold or transferred without the prior written consent of PlayFirst, Inc. 
-- All rights reserved.
-- --------------------------------------------------------------------------
require( "scripts/style.lua" );


TittleYellow	= Color(224,202,32,255);
TittleAqua      = Color(140,230,251,255);
TittleBlack		= Color(12,24,29,255);
TittleOrange	= Color(241,120,39,255);
TittleGreen		= Color(22,207,140,255);
TittlePlayGreen	= Color(110,255,161,255);
TittleNameGreen	= Color(159,226,137,255);
DeepAquaColor	= Color(140,230,251,255);
GameAquaColor	= Color(32,60,66,255);


PlayerFont = {
  standardFont,
  14,
  GreenFitness
};
SmallFont = {
  standardFont,
  11,
  TittleAqua
};
UpgradeButtonFont = {
  standardFont,
  14,
  TittleAqua
};
SmallFontBlack = {
  standardFont,
  14,
  TittleBlack
};
PlayerSmallFont = {
  standardFont,
  11,
  TittleNameGreen
};
PopupFont = {
	standardFont,
	24,
	AquaColor
};
PopupCopyright = {
	copyrightFont,
	24,
	AquaColor
};
PopupFontOrange = {
	standardFont,
	20,
	TittleAqua
};
BigPopupFont = {
	standardFont,
	32,
	AquaColor
};

NormalHelpFont = {
	standardFont,
	14,
	AquaColor
};
NormalHelpFont2 = {
	standardFont,
	13,
	AquaColor
};
BtnFont = {
	standardFont,
	12,
	TittleAqua
};
IngameFont = {
	standardFont,
	13,
	GameAquaColor
};
NormalHelpFont3 = {
	standardFont,
	16,
	AquaColor
};
--//////////////////////////////////////////////////////////////Tittle hud
FitnessButtonTittleGreen = {
	"images/ui/buttons/but31.png",
	"images/ui/buttons/but33.png",
	"images/ui/buttons/but32.png"
};
FitnessButtonTittleSmallBlue  = {
	"images/ui/buttons/but011.png",
	"images/ui/buttons/but013.png",
	"images/ui/buttons/but012.png"
};

FitnessButtonTittleSmallBlueFlashing  = {
	"images/ui/buttons/but011.png",
	"images/ui/buttons/but012.png",
	"images/ui/buttons/but012.png",
	"images/ui/buttons/but012.png"		-- Used for toggle effect higlight
};

FitnessButtonTittleYellow = {
	"images/ui/buttons/but21.png",
	"images/ui/buttons/but23.png",
	"images/ui/buttons/but22.png"
};
FitnessButtonTittleBlue = {
	"images/ui/buttons/but41.png",
	"images/ui/buttons/but43.png",
	"images/ui/buttons/but42.png"
};

FitnessButtonComicBlue = {
	"images/ui/buttons/comicbtn01.png",
	"images/ui/buttons/comicbtn03.png",
	"images/ui/buttons/comicbtn02.png"
};
FitnessButtonTittleFlatBlue = {
	"images/ui/buttons/but71.png",
	"images/ui/buttons/but73.png",
	"images/ui/buttons/but72.png"
};
FitnessButtonTittleXLBlue = {
	"images/ui/buttons/but61.png",
	"images/ui/buttons/but63.png",
	"images/ui/buttons/but62.png"	
};
FitnessButtonSharpXlBlue = {
	"images/ui/buttons/buttonbluesharp01.png",
	"images/ui/buttons/buttonbluesharp03.png",
	"images/ui/buttons/buttonbluesharp02.png"	
};
FitnessButtonGreenSharp = {
	"images/ui/buttons/tugboutonrelease01.png",
	"images/ui/buttons/tugboutonrelease03.png",
	"images/ui/buttons/tugboutonrelease02.png"	
};
FitnessButtonTittleQuit = {
	"images/ui/buttons/quit01.png",
	"images/ui/buttons/quit03.png",
	"images/ui/buttons/quit02.png"
};
CheckboxButtonGraphicsFitness = {
	"images/ui/buttons/nocheckbox01",
	"images/ui/buttons/iconcheck",
	"images/ui/buttons/nocheckbox01",
	"images/ui/buttons/iconcheck"
};
--//////////////////////////////////////////////////////////////////////////Source Attributs
FitnessButtonStyleTittleSourceYellow = {
	font		= standardFont,
	policeSize	= 14,
	type		= kPush,
	color		= TittleAqua,
	sound		= szNameButtonClick,
	mask		= "assets/images/ui/buttons/big_mask"
};
FitnessButtonStyleTittleSourceGreen = {
	font		= standardFont,
	policeSize	= 14,
	type		= kPush,
	color		= TittleGreen,
	sound		= szNameButtonClick,
	mask		= "assets/images/ui/buttons/big_mask"
};
FitnessButtonStyleTittleSourceSmallBlue = {
	font		= standardFont,
	policeSize	= 12,
	type		= kPush,
	color		= TittleAqua,
	sound		= szNameButtonClick,
	mask		= "assets/images/ui/buttons/small_mask"
};
FitnessButtonStyleTittleSourceSmallBlue2 = {
	font		= standardFont,
	policeSize	= 12,
	type		= kPush,
	color		= TittleAqua,
	sound		= szNameButtonClick,
	mask		= "assets/images/ui/buttons/small_mask2"
};
FitnessButtonStyleTittleSourceSmallBlue3 = {
	font		= standardFont,
	policeSize	= 12,
	type		= kPush,
	color		= TittleBlack,
	sound		= szNameButtonClick,
	mask		= "assets/images/ui/buttons/small_mask2"
};
FitnessButtonStyleTittleSourceSmallBlue4 = {
	font		= standardFont,
	policeSize	= 18,
	type		= kPush,
	color		= TittleAqua,
	sound		= szNameButtonClick,
	mask		= "assets/images/ui/buttons/small_mask2"
};
FitnessButtonStyleTittleSourceSmallBlueFlash = {
	font		= standardFont,
	policeSize	= 12,
	type		= kPush,
	color		= GameAquaColor,
	sound		= szNameButtonClick,
	mask		= "assets/images/ui/buttons/small_mask"
};
FitnessButtonStyleTittleSourceSmallBlueFlash2 = {
	font		= standardFont,
	policeSize	= 12,
	type		= kPush,
	color		= TittleAqua,
	sound		= szNameButtonClick,
	mask		= "assets/images/ui/buttons/small_mask"
};

FitnessButtonStyleComicSourceFlatBlue = {
	font		= standardFont,
	policeSize	= 12,
	type		= kPush,
	color		= TittleAqua,
	sound		= szNameButtonClick,
	mask		= "assets/images/ui/buttons/comicbtn_mask"
};

FitnessButtonStyleTittleSourceFlatBlue = {
	font		= standardFont,
	policeSize	= 12,
	type		= kPush,
	color		= TittleAqua,
	sound		= szNameButtonClick,
	mask		= "assets/images/ui/buttons/but72_mask"
};
FitnessButtonStyleTittleSourceFlatBlueTxInside = {
	font		= standardFont,
	policeSize	= 14,
	type		= kPush,
	color		= AquaColor,
	sound		= szNameButtonClick,
	mask		= "assets/images/ui/buttons/but72_mask"
};
FitnessButtonStyleTittleSourceXLBlue = {
	font		= standardFont,
	policeSize	= 14,
	type		= kPush,
	color		= TittleAqua,
	sound		= szNameButtonClick,
	mask		= "assets/images/ui/buttons/xl_mask"
};
FitnessButtonStyleTittleSourceXLBlueTxInside = {
	font		= standardFont,
	policeSize	= 14,
	type		= kPush,
	color		= AquaColor,
	sound		= szNameButtonClick,
	mask		= "assets/images/ui/buttons/xl_mask"
};
FitnessButtonStyleTittleSourceSharpXLBlue = {
	font		= standardFont,
	policeSize	= 14,
	type		= kPush,
	color		= AquaColor,
	sound		= szNameButtonClick,
	mask		= "assets/images/ui/buttons/buttonbluesharp04"
};
FitnessButtonStyleTittleSourceSharpGreen = {
	font		= standardFont,
	policeSize	= 14,
	type		= kPush,
	color		= TittleBlack,
	sound		= "",
	mask		= "assets/images/ui/buttons/release_mask"
};
FitnessButtonStyleTittleSourceRectangle = {
	font		= standardFont,
	policeSize	= 10,
	type		= kPush,
	color		= TittleAqua,
	sound		= szNameButtonClick,
	mask		= "assets/images/ui/buttons/rectangle_mask"
};
--//////////////////////////////////////////////////////////////////////////Style Button
FitnessButtonStyleTittleYellow = {
	graphics		= FitnessButtonTittleYellow,
	buttonAttribut	= FitnessButtonStyleTittleSourceYellow,
	w				= 128,
	h				= 128,
	rolloversound = szRollOverSound,
	tx				= -1,	-- x axe for text from center of asset button
	ty				= 45,	-- y axe for text from center of asset button
	iconX			= 0,	-- x axe for icon from center of asset button
	iconY			= 0,	-- y axe for icon from center of asset button
	iconScale		= 1.2
};
FitnessButtonStyleTittleGreen = {
	graphics		= FitnessButtonTittleGreen,
	buttonAttribut	= FitnessButtonStyleTittleSourceGreen,
	w				= 128,
	h				= 128,
	rolloversound = szRollOverSound,
	tx				= -1,	-- x axe for text from center of asset button
	ty				= 45,	-- y axe for text from center of asset button
	iconX			= 0,	-- x axe for icon from center of asset button
	iconY			= 0,	-- y axe for icon from center of asset button
	iconScale		= 1.2
};
FitnessButtonStyleTittleSmallBlue = {
	graphics		= FitnessButtonTittleSmallBlue,
	buttonAttribut	= FitnessButtonStyleTittleSourceSmallBlue,
	w				= 64,
	h				= 64,
	rolloversound = szRollOverSound,
	flags			= kHAlignCenter + kHAlignCenter,
	tx				= 0,	-- x axe for text from center of asset button
	ty				= 20,	-- y axe for text from center of asset button
	iconX			= 0,	-- x axe for icon from center of asset button  
	iconY			= 0	-- y axe for icon from center of asset button
};
FitnessButtonStyleTittleSmallBlue2 = {
	graphics		= FitnessButtonTittleSmallBlue,
	buttonAttribut	= FitnessButtonStyleTittleSourceSmallBlue2,
	w				= 64,
	h				= 80,
	rolloversound = szRollOverSound,
	flags			= kHAlignCenter + kVAlignCenter,
	tx				= 0,	-- x axe for text from center of asset button
	ty				= 21,	-- y axe for text from center of asset button
	iconX			= 0,	-- x axe for icon from center of asset button
	iconY			= -10	-- y axe for icon from center of asset button
};
FitnessButtonStyleTittleSmallBlue3 = {
	graphics		= FitnessButtonTittleSmallBlue,
	buttonAttribut	= FitnessButtonStyleTittleSourceSmallBlueFlash,
	w				= 64,
	h				= 80,
	rolloversound = szRollOverSound,
	flags			= kHAlignCenter | kVAlignCenter,
	tx				= 0,	-- x axe for text from center of asset button
	ty				= 20,	-- y axe for text from center of asset button
	iconX			= 0,	-- x axe for icon from center of asset button
	iconY			= -15	-- y axe for icon from center of asset button
};

FitnessButtonStyleTittleSmallBlue4 = {
	graphics		= FitnessButtonTittleSmallBlue,
	buttonAttribut	= FitnessButtonStyleTittleSourceSmallBlue4,
	w				= 64,
	h				= 64,
	rolloversound = szRollOverSound,
	flags			= kHAlignCenter + kHAlignCenter,
	tx				= 0,	-- x axe for text from center of asset button
	ty				= -22,	-- y axe for text from center of asset button
	iconX			= 0,	-- x axe for icon from center of asset button  
	iconY			= 0	-- y axe for icon from center of asset button
};

FitnessButtonStyleTittleSmallBlueFlashing = {
	type			= kToggle,
	graphics		= FitnessButtonTittleSmallBlueFlashing,
	buttonAttribut	= FitnessButtonStyleTittleSourceSmallBlueFlash,
	w				= 64,
	h				= 80,
	rolloversound = szRollOverSound,
	flags			= kHAlignCenter | kVAlignTop,
	tx				= 0,	-- x axe for text from center of asset button
	ty				= 20,	-- y axe for text from center of asset button
	iconX			= 0,	-- x axe for icon from center of asset button
	iconY			= -8,	-- y axe for icon from center of asset button
};


FitnessButtonStyleComicBlue = {
	graphics		= FitnessButtonComicBlue,
	buttonAttribut	= FitnessButtonStyleComicSourceFlatBlue,
	w				= 59,
	h				= 43,
	rolloversound	= szRollOverSound,
	tx				= 0,	-- x axe for text from center of asset button
	ty				= 0,	-- y axe for text from center of asset button
	iconX			= 0,	-- x axe for icon from center of asset button
	iconY			= 0,	-- y axe for icon from center of asset button
};

FitnessButtonStyleTittleFlatBlue = {
	graphics		= FitnessButtonTittleFlatBlue,
	buttonAttribut	= FitnessButtonStyleTittleSourceFlatBlue,
	w				= 337,
	h				= 41,
	rolloversound = szRollOverSound,
	tx				= 0,	-- x axe for text from center of asset button
	ty				= 30,	-- y axe for text from center of asset button
	iconX			= 0,	-- x axe for icon from center of asset button
	iconY			= -3	-- y axe for icon from center of asset button
};
FitnessButtonStyleTittleFlatBlueTxInside = {
	graphics		= FitnessButtonTittleFlatBlue,
	buttonAttribut	= FitnessButtonStyleTittleSourceFlatBlueTxInside,
	w				= 337,
	h				= 41,
	rolloversound = szRollOverSound,
	tx				= 0,	-- x axe for text from center of asset button
	ty				= 0,	-- y axe for text from center of asset button
	iconX			= 0,	-- x axe for icon from center of asset button
	iconY			= -3	-- y axe for icon from center of asset button
};
FitnessButtonStyleTittleXLBlue = {
	graphics		= FitnessButtonTittleXLBlue,
	buttonAttribut	= FitnessButtonStyleTittleSourceXLBlue,
	w				= 128,
	h				= 128,
	rolloversound = szRollOverSound,
	tx				= 0,	-- x axe for text from center of asset button
	ty				= 25,	-- y axe for text from center of asset button
	iconScale		= 0.8,
};
FitnessButtonStyleTittleXLBlueTxInside = {
	graphics		= FitnessButtonTittleXLBlue,
	buttonAttribut	= FitnessButtonStyleTittleSourceXLBlueTxInside,
	w				= 128,
	h				= 128,
	rolloversound = szRollOverSound,
	flags = kHAlignCenter + kVAlignCenter,
	tx				= 0,	-- x axe for text from center of asset button
	ty				= 0,	-- y axe for text from center of asset button
};
FitnessButtonStyleSharpXLBlue = {
	graphics		= FitnessButtonSharpXlBlue,
	buttonAttribut	= FitnessButtonStyleTittleSourceSharpXLBlue,
	w				= 113,
	h				= 63,
	rolloversound = szRollOverSound,
	tx				= 0,	-- x axe for text from center of asset button
	ty				= 23,	-- y axe for text from center of asset button
};
FitnessButtonStyleRelease = {
	graphics		= FitnessButtonGreenSharp,
	buttonAttribut	= FitnessButtonStyleTittleSourceSharpGreen,
	w				= 113,
	h				= 63,
	rolloversound = "",--szRollOverSound,
	tx				= 0,	-- x axe for text from center of asset button
	ty				= 23,	-- y axe for text from center of asset button
};
FitnessButtonStyleQuit = {
	graphics		= FitnessButtonTittleQuit,
	buttonAttribut	= FitnessButtonStyleTittleSourceRectangle,
	w				= 68,
	h				= 32,
	rolloversound = szRollOverSound,
	tx				= -13,	-- x axe for text from center of asset button
	ty				= 0,	-- y axe for text from center of asset button
	iconX			= 15,	-- x axe for icon from center of asset button
	iconY			= 0,	-- y axe for icon from center of asset button
	iconScale		= 0.7
};
CheckboxButtonStyleFitness = {
	parent = DefaultStyle,
	font = StandardButtonFont,
	type = kToggle,
	sound = kDefaultButtonSound,
	graphics = CheckboxButtonGraphicsFitness,
	--mask= "images/ui/buttons/mask_checkbox01",
};
SliderStyleFitness =
{
	parent=DefaultStyle,
	railtop = "images/ui/buttons/invisiblebarmetter",
	railmid = "images/ui/buttons/invisiblebarmetter",
	railbot = "images/ui/buttons/invisiblebarmetter",
	sliderimage = "images/slider/boutonoption01",
	sliderrollimage = "images/slider/boutonoption02",

	yoffset = -1, -- scoot the slider down by one pixel to center it.
};